/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3193;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5573;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEChunkMap;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEEntityTrackingSection;
import qouteall.imm_ptl.core.ducks.IESectionedEntityCache;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mc_utils.MyNbtTextFormatter;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.common.mc_util.IELevelEntityGetterAdapter;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class McHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Placeholder placeholder = new Placeholder();

    public static class_2960 newResourceLocation(String a, String b) {
        return class_2960.method_60655((String)a, (String)b);
    }

    public static class_2960 newResourceLocation(String a) {
        return class_2960.method_60654((String)a);
    }

    @Deprecated
    public static IEChunkMap getIEChunkMap(class_5321<class_1937> dimension) {
        return (IEChunkMap)McHelper.getServerWorld(dimension).method_14178().field_17254;
    }

    @Deprecated
    public static List<class_3222> getRawPlayerList() {
        return MiscHelper.getServer().method_3760().method_14571();
    }

    public static class_243 lastTickPosOf(class_1297 entity) {
        return new class_243(entity.field_6014, entity.field_6036, entity.field_5969);
    }

    @Deprecated
    public static class_3218 getOverWorldOnServer() {
        return MiscHelper.getServer().method_3847(class_1937.field_25179);
    }

    public static void serverLog(class_3222 player, String text) {
        Helper.log(text);
        player.method_7353((class_2561)class_2561.method_43470((String)text), false);
    }

    public static long getServerGameTime() {
        return McHelper.getOverWorldOnServer().method_8510();
    }

    public static <T> void performMultiThreadedFindingTaskOnServer(MinecraftServer server, Stream<T> stream, Predicate<T> predicate, IntPredicate taskWatcher, Consumer<T> onFound, Runnable onNotFound, Runnable finalizer) {
        int[] progress = new int[1];
        Helper.SimpleBox<Boolean> isAborted = new Helper.SimpleBox<Boolean>(false);
        Helper.SimpleBox<Runnable> finishBehavior = new Helper.SimpleBox<Runnable>(() -> Helper.err("Error Occured"));
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = stream.peek(obj -> {
                    progress[0] = progress[0] + 1;
                }).filter(predicate).findFirst().orElse(null);
                finishBehavior.obj = result != null ? () -> onFound.accept(result) : onNotFound;
            }
            catch (Throwable t) {
                t.printStackTrace();
                finishBehavior.obj = () -> t.printStackTrace();
            }
        }, class_156.method_18349());
        ServerTaskList.of(server).addTask(() -> {
            if (future.isDone()) {
                if (!((Boolean)isAborted.obj).booleanValue()) {
                    ((Runnable)finishBehavior.obj).run();
                    finalizer.run();
                } else {
                    Helper.log("Future done but the task is aborted");
                }
                return true;
            }
            if (future.isCancelled()) {
                Helper.err("The future is cancelled");
                finalizer.run();
                return true;
            }
            if (future.isCompletedExceptionally()) {
                Helper.err("The future is completed exceptionally");
                finalizer.run();
                return true;
            }
            boolean shouldContinue = taskWatcher.test(progress[0]);
            if (!shouldContinue) {
                isAborted.obj = true;
                future.cancel(true);
                finalizer.run();
                return true;
            }
            return false;
        });
    }

    public static <ENTITY extends class_1297> List<ENTITY> getEntitiesNearby(class_1937 world, class_243 center, Class<ENTITY> entityClass, double range) {
        return McHelper.findEntitiesRough(entityClass, world, center, (int)(range / 16.0 + 1.0), e -> true);
    }

    public static <ENTITY extends class_1297> List<ENTITY> getEntitiesNearby(class_1297 center, Class<ENTITY> entityClass, double range) {
        return McHelper.getEntitiesNearby(center.method_37908(), center.method_19538(), entityClass, range);
    }

    public static int getLoadDistanceOnServer(MinecraftServer server) {
        return server.method_3760().method_14568();
    }

    @IPVanillaCopy
    public static int getPlayerLoadDistance(class_3222 player) {
        assert (player.method_5682() != null);
        int loadDistanceOnServer = McHelper.getLoadDistanceOnServer(player.method_5682());
        return class_3532.method_15340((int)player.method_52371(), (int)2, (int)loadDistanceOnServer);
    }

    public static void setPosAndLastTickPos(class_1297 entity, class_243 pos, class_243 lastTickPos) {
        entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        entity.field_6038 = lastTickPos.field_1352;
        entity.field_5971 = lastTickPos.field_1351;
        entity.field_5989 = lastTickPos.field_1350;
        entity.field_6014 = lastTickPos.field_1352;
        entity.field_6036 = lastTickPos.field_1351;
        entity.field_5969 = lastTickPos.field_1350;
    }

    public static void setPosAndLastTickPosWithoutTriggeringCallback(class_1297 entity, class_243 pos, class_243 lastTickPos) {
        ((IEEntity)entity).ip_setPositionWithoutTriggeringCallback(pos);
        entity.field_6038 = lastTickPos.field_1352;
        entity.field_5971 = lastTickPos.field_1351;
        entity.field_5989 = lastTickPos.field_1350;
        entity.field_6014 = lastTickPos.field_1352;
        entity.field_6036 = lastTickPos.field_1351;
        entity.field_5969 = lastTickPos.field_1350;
    }

    public static class_243 getEyePos(class_1297 entity) {
        class_243 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        return entity.method_19538().method_1019(eyeOffset);
    }

    public static class_243 getLastTickEyePos(class_1297 entity) {
        class_243 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        return McHelper.lastTickPosOf(entity).method_1019(eyeOffset);
    }

    public static void setEyePos(class_1297 entity, class_243 eyePos, class_243 lastTickEyePos) {
        class_243 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        McHelper.setPosAndLastTickPos(entity, eyePos.method_1020(eyeOffset), lastTickEyePos.method_1020(eyeOffset));
    }

    public static class_243 getVehicleOffsetFromPassenger(class_1297 vehicle, class_1297 passenger) {
        class_243 vehicleAttachmentPoint = passenger.method_55668(vehicle);
        return vehicleAttachmentPoint;
    }

    public static void adjustVehicle(class_1297 entity) {
        class_1297 vehicle = entity.method_5854();
        if (vehicle == null) {
            return;
        }
        class_243 vehicleOffset = McHelper.getVehicleOffsetFromPassenger(vehicle, entity);
        class_243 currVelocity = vehicle.method_18798();
        class_243 newVehiclePos = entity.method_19538().method_1019(vehicleOffset);
        class_243 newVehicleLastTickPos = McHelper.lastTickPosOf(entity).method_1019(vehicleOffset);
        vehicle.method_5814(newVehiclePos.method_10216(), newVehiclePos.method_10214(), newVehiclePos.method_10215());
        vehicle.method_5759(newVehiclePos.method_10216(), newVehiclePos.method_10214(), newVehiclePos.method_10215(), vehicle.method_36454(), vehicle.method_36455(), 0);
        McHelper.setPosAndLastTickPos(vehicle, newVehiclePos, newVehicleLastTickPos);
        vehicle.method_18799(currVelocity);
    }

    public static class_2818 getServerChunkIfPresent(class_5321<class_1937> dimension, int x, int z) {
        class_3193 chunkHolder_ = McHelper.getIEChunkMap(dimension).ip_getChunkHolder(class_1923.method_8331((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.method_16144();
    }

    public static class_2818 getServerChunkIfPresent(class_3218 world, int x, int z) {
        class_3193 chunkHolder_ = ((IEChunkMap)world.method_14178().field_17254).ip_getChunkHolder(class_1923.method_8331((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.method_16144();
    }

    @Deprecated
    public static <ENTITY extends class_1297> Stream<ENTITY> getServerEntitiesNearbyWithoutLoadingChunk(class_1937 world, class_243 center, Class<ENTITY> entityClass, double range) {
        return McHelper.findEntitiesRough(entityClass, world, center, (int)(range / 16.0), e -> true).stream();
    }

    public static void updateBoundingBox(class_1297 player) {
        player.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
    }

    public static void updatePosition(class_1297 entity, class_243 pos) {
        entity.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static <T extends class_1297> List<T> getEntitiesRegardingLargeEntities(class_1937 world, class_238 box, double maxEntitySizeHalf, Class<T> entityClass, Predicate<T> predicate) {
        return McHelper.findEntitiesByBox(entityClass, world, box, maxEntitySizeHalf, predicate);
    }

    public static Portal copyEntity(Portal portal) {
        Portal newPortal = (Portal)portal.method_5864().method_5883(portal.method_37908());
        Validate.notNull((Object)newPortal);
        newPortal.method_5651(portal.method_5647(new class_2487()));
        return newPortal;
    }

    public static boolean getDoesRegionFileExist(class_5321<class_1937> toDimension, class_2338 toPos) {
        class_1923 chunkPos = new class_1923(toPos);
        class_32.class_5143 storageSource = MiscHelper.getServer().field_23784;
        Path regionFilePath = storageSource.method_27424(toDimension).resolve("region").resolve("r." + chunkPos.method_17885() + "." + chunkPos.method_17886() + ".mca");
        return regionFilePath.toFile().exists();
    }

    public static class_5250 getLinkText(String link) {
        return class_2561.method_43470((String)link).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, link)).method_30938(Boolean.valueOf(true)));
    }

    public static void validateOnServerThread() {
        Validate.isTrue((Thread.currentThread() == MiscHelper.getServer().method_3777() ? 1 : 0) != 0, (String)"must be on server thread", (Object[])new Object[0]);
    }

    public static void invokeCommandAs(class_1297 commandSender, List<String> commandList) {
        class_2168 commandSource = commandSender.method_5671().method_9206(2).method_9217();
        MinecraftServer server = commandSender.method_5682();
        assert (server != null);
        class_2170 commandManager = server.method_3734();
        for (String command : commandList) {
            commandManager.method_44252(commandSource, command);
        }
    }

    public static void resendSpawnPacketToTrackers(class_1297 entity) {
        McHelper.getIEChunkMap((class_5321<class_1937>)entity.method_37908().method_27983()).ip_resendSpawnPacketToTrackers(entity);
    }

    public static void sendToTrackers(class_1297 entity, class_2596<?> packet) {
        class_3898.class_3208 entityTracker = (class_3898.class_3208)McHelper.getIEChunkMap((class_5321<class_1937>)entity.method_37908().method_27983()).ip_getEntityTrackerMap().get(entity.method_5628());
        if (entityTracker == null) {
            return;
        }
        entityTracker.method_18734(packet);
    }

    @Nullable
    public static class_238 getWallBox(class_1937 world, IntBox glassArea) {
        Stream<class_2338> blockPosStream = glassArea.stream();
        return McHelper.getWallBox(world, blockPosStream);
    }

    @Nullable
    public static class_238 getWallBox(class_1937 world, Stream<class_2338> blockPosStream) {
        return blockPosStream.map(blockPos -> {
            class_265 collisionShape = world.method_8320(blockPos).method_26220((class_1922)world, blockPos);
            if (collisionShape.method_1110()) {
                return null;
            }
            return collisionShape.method_1107().method_997(class_243.method_24954((class_2382)blockPos));
        }).filter(b -> b != null).reduce(class_238::method_991).orElse(null);
    }

    public static boolean isServerChunkFullyLoaded(class_3218 world, class_1923 chunkPos) {
        class_2818 chunk = McHelper.getServerChunkIfPresent((class_5321<class_1937>)world.method_27983(), chunkPos.field_9181, chunkPos.field_9180);
        if (chunk == null) {
            return false;
        }
        boolean entitiesLoaded = world.method_37116(chunkPos.method_8324());
        return entitiesLoaded;
    }

    public static ChunkAccessor getChunkAccessor(class_1937 world) {
        if (world.method_8608()) {
            return (arg_0, arg_1) -> ((class_1937)world).method_8497(arg_0, arg_1);
        }
        return (x, z) -> McHelper.getServerChunkIfPresent((class_3218)world, x, z);
    }

    public static <T extends class_1297> List<T> findEntities(Class<T> entityClass, class_5577<class_1297> entityLookup, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Predicate<T> predicate) {
        ArrayList result = new ArrayList();
        McHelper.foreachEntities(entityClass, entityLookup, chunkXStart, chunkXEnd, chunkYStart, chunkYEnd, chunkZStart, chunkZEnd, entity -> {
            if (predicate.test(entity)) {
                result.add(entity);
            }
        });
        return result;
    }

    @Nullable
    public static <T extends class_1297, R> R traverseEntities(Class<T> entityClass, class_5577<class_1297> entityLookup, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Function<T, R> function) {
        Validate.isTrue((chunkXEnd >= chunkXStart ? 1 : 0) != 0);
        Validate.isTrue((chunkYEnd >= chunkYStart ? 1 : 0) != 0);
        Validate.isTrue((chunkZEnd >= chunkZStart ? 1 : 0) != 0);
        Validate.isTrue((chunkXEnd - chunkXStart < 1000 ? 1 : 0) != 0, (String)"range too big", (Object[])new Object[0]);
        Validate.isTrue((chunkZEnd - chunkZStart < 1000 ? 1 : 0) != 0, (String)"range too big", (Object[])new Object[0]);
        class_5575 typeFilter = class_5575.method_31795(entityClass);
        class_5573<?> cache = ((IELevelEntityGetterAdapter)entityLookup).getCache();
        return (R)((IESectionedEntityCache)cache).ip_traverseSectionInBox(chunkXStart, chunkXEnd, chunkYStart, chunkYEnd, chunkZStart, chunkZEnd, entityTrackingSection -> ((IEEntityTrackingSection)entityTrackingSection).ip_traverse(typeFilter, function));
    }

    public static <E extends class_1297, R> R traverseEntitiesByBox(Class<E> entityClass, class_1937 world, class_238 box, double maxEntityRadius, Function<E, R> function) {
        return (R)McHelper.traverseEntitiesByApproximateRegion(entityClass, world, box, maxEntityRadius, entity -> {
            if (entity.method_5829().method_994(box)) {
                return function.apply(entity);
            }
            return null;
        });
    }

    public static <T extends class_1297> void foreachEntities(Class<T> entityClass, class_5577<class_1297> entityLookup, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Consumer<T> consumer) {
        McHelper.traverseEntities(entityClass, entityLookup, chunkXStart, chunkXEnd, chunkYStart, chunkYEnd, chunkZStart, chunkZEnd, e -> {
            consumer.accept(e);
            return null;
        });
    }

    public static <T extends class_1297> List<T> findEntitiesRough(Class<T> entityClass, class_1937 world, class_243 center, int radiusChunks, Predicate<T> predicate) {
        if (radiusChunks <= 0) {
            radiusChunks = 1;
        }
        if (radiusChunks > 32) {
            radiusChunks = 32;
        }
        class_4076 sectionPos = class_4076.method_18680((class_2374)center);
        return McHelper.findEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), sectionPos.method_18674() - radiusChunks, sectionPos.method_18674() + radiusChunks, sectionPos.method_18683() - radiusChunks, sectionPos.method_18683() + radiusChunks, sectionPos.method_18687() - radiusChunks, sectionPos.method_18687() + radiusChunks, predicate);
    }

    public static <T extends class_1297> List<T> findEntitiesByBox(Class<T> entityClass, class_1937 world, class_238 box, double maxEntityRadius, Predicate<T> predicate) {
        ArrayList result = new ArrayList();
        McHelper.foreachEntitiesByBox(entityClass, world, box, maxEntityRadius, predicate, result::add);
        return result;
    }

    public static <T extends class_1297> void foreachEntitiesByBox(Class<T> entityClass, class_1937 world, class_238 box, double maxEntityRadius, Predicate<T> predicate, Consumer<T> consumer) {
        McHelper.foreachEntitiesByBoxApproximateRegions(entityClass, world, box, maxEntityRadius, entity -> {
            if (entity.method_5829().method_994(box) && predicate.test(entity)) {
                consumer.accept(entity);
            }
        });
    }

    public static <T extends class_1297> void foreachEntitiesByBoxApproximateRegions(Class<T> entityClass, class_1937 world, class_238 box, double maxEntityRadius, Consumer<T> consumer) {
        int xMin = (int)Math.floor(box.field_1323 - maxEntityRadius);
        int yMin = (int)Math.floor(box.field_1322 - maxEntityRadius);
        int zMin = (int)Math.floor(box.field_1321 - maxEntityRadius);
        int xMax = (int)Math.ceil(box.field_1320 + maxEntityRadius);
        int yMax = (int)Math.ceil(box.field_1325 + maxEntityRadius);
        int zMax = (int)Math.ceil(box.field_1324 + maxEntityRadius);
        McHelper.foreachEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), xMin >> 4, xMax >> 4, yMin >> 4, yMax >> 4, zMin >> 4, zMax >> 4, consumer);
    }

    public static <E extends class_1297, R> R traverseEntitiesByApproximateRegion(Class<E> entityClass, class_1937 world, class_238 box, double maxEntityRadius, Function<E, R> function) {
        int xMin = (int)Math.floor(box.field_1323 - maxEntityRadius);
        int yMin = (int)Math.floor(box.field_1322 - maxEntityRadius);
        int zMin = (int)Math.floor(box.field_1321 - maxEntityRadius);
        int xMax = (int)Math.ceil(box.field_1320 + maxEntityRadius);
        int yMax = (int)Math.ceil(box.field_1325 + maxEntityRadius);
        int zMax = (int)Math.ceil(box.field_1324 + maxEntityRadius);
        return McHelper.traverseEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), xMin >> 4, xMax >> 4, yMin >> 4, yMax >> 4, zMin >> 4, zMax >> 4, function);
    }

    public static <T extends class_1297> void foreachEntitiesByPointAndRoughRadius(Class<T> entityClass, class_1937 world, class_243 point, int roughRadius, Consumer<T> consumer) {
        McHelper.traverseEntitiesByPointAndRoughRadius(entityClass, world, point, roughRadius, entity -> {
            consumer.accept(entity);
            return null;
        });
    }

    public static <T extends class_1297, R> void traverseEntitiesByPointAndRoughRadius(Class<T> entityClass, class_1937 world, class_243 point, int roughRadius, Function<T, R> function) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)class_2338.method_49638((class_2374)point));
        int roughRadiusChunks = (int)Math.ceil((double)roughRadius / 16.0);
        if (roughRadiusChunks == 0) {
            roughRadiusChunks = 1;
        }
        McHelper.traverseEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), sectionPos.method_18674() - roughRadiusChunks, sectionPos.method_18674() + roughRadiusChunks, sectionPos.method_18683() - roughRadiusChunks, sectionPos.method_18683() + roughRadiusChunks, sectionPos.method_18687() - roughRadiusChunks, sectionPos.method_18687() + roughRadiusChunks, function);
    }

    public static class_2960 dimensionTypeId(class_5321<class_1937> dimType) {
        return dimType.method_29177();
    }

    public static <T> String serializeToJson(T object, Codec<T> codec) {
        DataResult r = codec.encode(object, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        JsonElement result = (JsonElement)r.getOrThrow();
        return IPGlobal.gson.toJson(result);
    }

    public static <T, Serialized> T decodeFailHard(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target) {
        return (T)((Pair)codec.decode(ops, target).getOrThrow(s -> {
            throw new MyDecodeException("Cannot decode" + s + String.valueOf(target));
        })).getFirst();
    }

    public static <Serialized> Serialized getElementFailHard(DynamicOps<Serialized> ops, Serialized target, String key) {
        return (Serialized)ops.get(target, key).getOrThrow(s -> {
            throw new MyDecodeException("Cannot find" + key + s + String.valueOf(target));
        });
    }

    public static <T, Serialized> void encode(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target, T object) {
        codec.encode(object, ops, target);
    }

    public static <Serialized, T> T decodeElementFailHard(DynamicOps<Serialized> ops, Serialized input, Codec<T> codec, String key) {
        return McHelper.decodeFailHard(codec, ops, McHelper.getElementFailHard(ops, input, key));
    }

    public static void sendMessageToFirstLoggedPlayer(MinecraftServer server, class_2561 text) {
        LOGGER.info("Message: {}", (Object)text.method_10851());
        ServerTaskList.of(server).addTask(() -> {
            List playerList = server.method_3760().method_14571();
            if (playerList.isEmpty()) {
                return false;
            }
            for (class_3222 player : playerList) {
                player.method_7353(text, false);
            }
            return true;
        });
    }

    public static Iterable<class_1297> getWorldEntityList(class_1937 world) {
        if (world.method_8608()) {
            return CHelper.getWorldEntityList(world);
        }
        if (world instanceof class_3218) {
            return ((class_3218)world).method_27909();
        }
        return (Iterable)((Object)Collections.emptyList().iterator());
    }

    public static void spawnServerEntity(class_1297 entity) {
        Validate.isTrue((!entity.method_37908().method_8608() ? 1 : 0) != 0);
        boolean spawned = entity.method_37908().method_8649(entity);
        if (!spawned) {
            LOGGER.error("Failed to spawn {} {}", (Object)entity, (Object)entity.method_37908());
        }
    }

    @Deprecated
    public static class_3218 getServerWorld(class_5321<class_1937> dim) {
        return McHelper.getServerWorld(MiscHelper.getServer(), dim);
    }

    @NotNull
    public static class_3218 getServerWorld(MinecraftServer server, class_5321<class_1937> dim) {
        class_3218 world = server.method_3847(dim);
        if (world == null) {
            throw new RuntimeException("Missing dimension " + String.valueOf(dim.method_29177()));
        }
        return world;
    }

    public static class_2561 compoundTagToTextSorted(class_2487 tag, String indent, int depth) {
        return new MyNbtTextFormatter(" ", 0).apply((class_2520)tag);
    }

    public static int getMinY(class_1936 world) {
        return world.method_31607();
    }

    public static int getMaxYExclusive(class_1936 world) {
        return world.method_31600();
    }

    public static int getMaxContentYExclusive(class_1936 world) {
        return world.method_8597().comp_653() + McHelper.getMinY(world);
    }

    public static int getMinSectionY(class_1936 world) {
        return world.method_32891();
    }

    public static int getMaxSectionYExclusive(class_1936 world) {
        return world.method_31597();
    }

    public static int getYSectionNumber(class_1936 world) {
        return McHelper.getMaxSectionYExclusive(world) - McHelper.getMinSectionY(world);
    }

    public static class_238 getBoundingBoxWithMovedPosition(class_1297 entity, class_243 newPos) {
        return entity.method_5829().method_997(newPos.method_1020(entity.method_19538()));
    }

    public static String readTextResource(class_2960 identifier) {
        String result = null;
        try {
            InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(identifier).get()).method_14482();
            result = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading " + String.valueOf(identifier), e);
        }
        return result;
    }

    public static class_243 getWorldVelocity(class_1297 entity) {
        return GravityChangerInterface.invoker.getWorldVelocity(entity);
    }

    public static void setWorldVelocity(class_1297 entity, class_243 newVelocity) {
        GravityChangerInterface.invoker.setWorldVelocity(entity, newVelocity);
    }

    public static class_243 getEyeOffset(class_1297 entity) {
        return GravityChangerInterface.invoker.getEyeOffset(entity);
    }

    public static class_243 getAxisWFromOrientation(DQuaternion quaternion) {
        return quaternion.getAxisW();
    }

    public static class_243 getAxisHFromOrientation(DQuaternion quaternion) {
        return quaternion.getAxisH();
    }

    public static class_243 getNormalFromOrientation(DQuaternion quaternion) {
        return quaternion.getNormal();
    }

    @Nullable
    public static class_1297 getEntityByUUID(class_1937 world, UUID portalId) {
        return (class_1297)((IEWorld)world).portal_getEntityLookup().method_31808(portalId);
    }

    public static class_2561 getDimensionName(class_5321<class_1937> dimension) {
        String path;
        String namespace = dimension.method_29177().method_12836();
        String translationkey = "dimension." + namespace + "." + (path = dimension.method_29177().method_12832());
        class_5250 component = class_2561.method_43471((String)translationkey);
        if (component.getString().equals(translationkey)) {
            String modName = O_O.getModName(namespace);
            return class_2561.method_43469((String)"imm_ptl.a_dimension_of", (Object[])new Object[]{modName != null ? modName : namespace}).method_27693(" (" + String.valueOf(dimension.method_29177()) + ")");
        }
        return component;
    }

    public static interface ChunkAccessor {
        public class_2818 getChunk(int var1, int var2);
    }

    public static class MyDecodeException
    extends RuntimeException {
        public MyDecodeException(String message) {
            super(message);
        }
    }

    public static class Placeholder {
    }
}

